
#include <iostream>

using namespace std;

// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl razlomak7.cpp


class Razlomak {
private:
    int num, den;      // Brojilac i imenilac.
public:
    Razlomak() {set(0, 1);}
    Razlomak(int n, int d) {set(n, d);}
    Razlomak(int n) {set(n, 1);}
    Razlomak(const Razlomak &src);

    void set(int n, int d) {num = n; den = d; normalize();}
    int get_num() const {return num;}
    int get_den() const {return den;}
    Razlomak add(const Razlomak &other);
    Razlomak mult(const Razlomak &other);
    Razlomak operator+(const Razlomak &other)
        {return add(other);}
    Razlomak operator*(const Razlomak &other)
        {return mult(other);}
    int operator==(const Razlomak &other);
    int operator<(const Razlomak &other);
    friend ostream &operator<<(ostream &os, Razlomak &fr);

private:
    void normalize();   // PKonvertovanje u standardan oblik.
    int gcf(int a, int b);     // Najveci zajednicki delilac.
    int lcm(int a, int b);     // Najmanji zajednicki sadrzalac.
};
        

int main()  {
    Razlomak f1(1,2);
    Razlomak f2(1,3);
    
    Razlomak f3 = f1 + f2 +1;
    cout << "1/2 +1/3 +1 = " << f3 << endl;        
    system("PAUSE");
    return 0;
}


// ---------------------------------------------------
// Funkcije klase Razlomak

Razlomak::Razlomak(Razlomak const &src) {
     num = src.num;
     den = src.den;
}

// Normalize: prevodi Razlomak u standardan oblik,
//  jedinstven za svaku matematicki razlicitu vrednost.
//
void Razlomak::normalize(){

    // Slucajevi sa nulom

    if (den == 0 || num == 0) {
        num = 0;
        den = 1;
    }

    // PPostavljanje negativnog znaka samo u brojilac.

    if (den < 0) {
        num *= -1;
        den *= -1;
    }

    // Izvajanje cinioca iz brojioca i imenioca.

    int n = gcf(num, den);
    num = num / n;
    den = den / n;
}

// Najveci zajednicki delilac
//
int Razlomak::gcf(int a, int b) {
    if (a % b == 0)
        return abs(b);
    else
        return gcf(b, a % b);
}

// Najmanji zajednicki sadrzalac
//
int Razlomak::lcm(int a, int b){
    int n = gcf(a, b);
    return a / n * b;
}

Razlomak Razlomak::add(const Razlomak &other) {
    int lcd = lcm(den, other.den);
    int quot1 = lcd/den;
    int quot2 = lcd/other.den;
    return Razlomak(num * quot1 + other.num * quot2, lcd);
    
}

Razlomak Razlomak::mult(const Razlomak &other) {
    return Razlomak(num * other.num, den * other.den);
}

int Razlomak::operator==(const Razlomak &other) {
    return (num == other.num && den == other.den);
}


// ---------------------------------------------------
//  FRIEND FUNCKCIJA KLASE Razlomak

ostream &operator<<(ostream &os, Razlomak &fr) {
    os << fr.num << "/" << fr.den;
    return os;
}

